// Okay, this header works just fine with gcc, but there isn't a way to tell
// Visual C++ to pack a struct.  Therefore, to use this header, every project
// that must have alignment set to 1 byte.

#ifndef PACKED_H__
#define PACKED_H__


#include <assert.h>
#include <stdlib.h>


#if defined(_MSC_VER)

#define PACKED_STRUCT(name) typedef struct {
#define END_STRUCT(name)    } name;

#elif defined(__linux__) || defined(__UNIX__)

#define PACKED_STRUCT(name) typedef struct {
#define END_STRUCT(name)    } __attribute__((packed)) name;

#endif


#define ASSERT_STRUCT_SIZE(name, size) \
static class name##_AssertStructSize__ \
{                                      \
public:                                \
  name##_AssertStructSize__()          \
  {                                    \
    assert(sizeof(name) == size);      \
    if (sizeof(name) != size)          \
      abort();                         \
  }                                    \
} name##_AssertStructSize___;


#endif
