#ifndef __MEMORYBUFFER_HPP
#define __MEMORYBUFFER_HPP


#include <stddef.h>
#include "Buffer.hpp"


class CMemoryBuffer : public CBuffer
{
public:
  CMemoryBuffer(dword size = 0, byte* data = NULL);
  ~CMemoryBuffer();

  virtual dword Size();
  virtual void  Seek(dword location);
  virtual dword Tell();

  // read functions
  virtual int  Read(int num_bytes, byte* bytes);
  virtual bool ReadByte(byte& b);
  virtual bool ReadWord(word& word);
  virtual bool ReadDword(dword& dword);

  // write functions
  virtual int  Write(int num_bytes, const byte* bytes);
  virtual bool WriteByte(byte b);
  virtual bool WriteWord(word w);
  virtual bool WriteDword(dword dw);

private:
  dword m_size;
  dword m_allocated;
  byte* m_data;

  dword m_location;
};


#endif
