#include <stdlib.h>
#include <string.h>
#include "MemoryBuffer.hpp"


// number of bytes to allocate at a time
#define BLOCK_SIZE 4096


#define ROUND_UP(size) (((size) + BLOCK_SIZE - 1) / BLOCK_SIZE * BLOCK_SIZE)


///////////////////////////////////////////////////////////////////////////////

CMemoryBuffer::CMemoryBuffer(dword size, byte* data)
: m_location(0)
{
  m_size      = size;
  m_allocated = ROUND_UP(size);
  m_data      = (byte*)malloc(m_allocated);  // use malloc and free so we can use realloc
  if (data != NULL)
    memcpy(m_data, data, size);
  else
    memset(m_data, 0, size);
}

///////////////////////////////////////////////////////////////////////////////

CMemoryBuffer::~CMemoryBuffer()
{
  realloc(m_data, 0);
}

///////////////////////////////////////////////////////////////////////////////

dword
CMemoryBuffer::Size()
{
  return m_size;
}

///////////////////////////////////////////////////////////////////////////////

void
CMemoryBuffer::Seek(dword location)
{
  m_location = location;
}

///////////////////////////////////////////////////////////////////////////////

dword
CMemoryBuffer::Tell()
{
  return m_location;
}

///////////////////////////////////////////////////////////////////////////////

int
CMemoryBuffer::Read(int num_bytes, byte* bytes)
{
  int _num_bytes = num_bytes;
  if (m_location + _num_bytes > m_size)
    _num_bytes = m_size - m_location;
  memcpy(bytes, m_data + m_location, _num_bytes);
  m_location += _num_bytes;
  return _num_bytes;
}

///////////////////////////////////////////////////////////////////////////////

bool
CMemoryBuffer::ReadByte(byte& b)
{
  if (m_location < m_size)
  {
    m_location++;
    b = m_data[m_location - 1];
    return true;
  }
  else
    return false;
}

///////////////////////////////////////////////////////////////////////////////

bool
CMemoryBuffer::ReadWord(word& w)
{
  byte a, b;
  if (!ReadByte(a))
    return false;
  if (!ReadByte(b))
    return false;
  w = (b << 8) + a;
  return true;
}

///////////////////////////////////////////////////////////////////////////////

bool
CMemoryBuffer::ReadDword(dword& dw)
{
  word a, b;
  if (!ReadWord(a))
    return false;
  if (!ReadWord(b))
    return false;
  dw = (b << 16) + a;
  return true;
}

///////////////////////////////////////////////////////////////////////////////

int
CMemoryBuffer::Write(int num_bytes, const byte* bytes)
{
  for (int i = 0; i < num_bytes; i++)
    if (!WriteByte(bytes[i]))
      return i;
  return num_bytes;
}

///////////////////////////////////////////////////////////////////////////////

bool
CMemoryBuffer::WriteByte(byte b)
{
  if (m_location == m_size)
  {
    // if the allocated size is too small, make it bigger!
    if (m_allocated == m_size)
    {
      m_allocated = ROUND_UP(m_size + 1);
      m_data = (byte*)realloc(m_data, m_allocated);
    }
  
    m_data[m_size] = b;
    m_size++;
  }
  else
    m_data[m_location] = b;

  m_location++;
  return true;
}

///////////////////////////////////////////////////////////////////////////////

bool
CMemoryBuffer::WriteWord(word w)
{
  if (!WriteByte((byte)((w >> 0) & 0xFF)))
    return false;
  if (!WriteByte((byte)((w >> 8) & 0xFF)))
    return false;
  return true;
}

///////////////////////////////////////////////////////////////////////////////

bool
CMemoryBuffer::WriteDword(dword dw)
{
  if (!WriteWord((word)((dw >>  0) & 0xFFFF)))
    return false;
  if (!WriteWord((word)((dw >> 16) & 0xFFFF)))
    return false;
  return true;
}

///////////////////////////////////////////////////////////////////////////////
