#ifndef __IMAGE32_HPP
#define __IMAGE32_HPP


#include <stdio.h>
#include "colorspace.h"


class CImage32
{
public:
  CImage32();
  CImage32(int width, int height);
  CImage32(const CImage32& image);
  ~CImage32();

  CImage32& operator=(const CImage32& image);

  void Create(int width, int height);
  void Clear();

  bool Load(const char* filename);
  bool Save(const char* filename) const;
  void Resize(int width, int height);
  void Rescale(int width, int height);

  int         GetWidth() const;
  int         GetHeight() const;
  RGBA        GetPixel(int x, int y) const;
  RGBA*       GetPixels();
  const RGBA* GetPixels() const;

  void FlipHorizontal();
  void FlipVertical();
  void Translate(int dx, int dy);
  void Rotate(double radians, bool autoSize);
  void RotateCW();
  void RotateCCW(); 

  void SetPixel(int x, int y, RGBA color);
  void Line(int x1, int y1, int x2, int y2, RGBA color);
  void Circle(int x, int y, int r, RGBA color, RGBA backcolor);
  void Rectangle(int x1, int y1, int x2, int y2, RGBA color, RGBA backcolor);

private:
  virtual void OnResize(int old_width, int old_height);

  bool Import_PNG(const char* filename);
  bool Import_BMP(const char* filename);
  bool BMP_ReadRGB(FILE *file, int imagesize, int bpp, BGRA* Pal);
  bool BMP_ReadRLE8(FILE *file, BGRA* Pal);
  bool BMP_ReadRLE4(FILE *file, int bpp, int NumPal, RGBA* Pal);
  bool Import_PCX(const char* filename);
  void PCX_ReadScanline(FILE* file, int scansize, byte* scanline);

  bool Export_PNG(const char* filename) const;

  double RotateX(double x, double y, double radians);
  double RotateY(double x, double y, double radians);

private:
  int   m_Width;
  int   m_Height;
  RGBA* m_Pixels;
};


inline int
CImage32::GetWidth() const
{
  return m_Width;
}


inline int
CImage32::GetHeight() const
{
  return m_Height;
}


inline RGBA
CImage32::GetPixel(int x, int y) const
{
  return m_Pixels[y * m_Width + x];
}


inline RGBA*
CImage32::GetPixels()
{
  return m_Pixels;
}


inline const RGBA*
CImage32::GetPixels() const
{
  return m_Pixels;
}


#endif
