#ifndef __FILEBUFFER_HPP
#define __FILEBUFFER_HPP


#include <stdio.h>
#include "Buffer.hpp"


class CFileBuffer : public CBuffer
{
public:
  CFileBuffer(const char* filename, bool open_existing = true);
  ~CFileBuffer();

  bool IsOpen() const;

  virtual dword Size();
  virtual void  Seek(dword location);
  virtual dword Tell();

  // read functions
  virtual int  Read(int num_bytes, byte* bytes);
  virtual bool ReadByte(byte& b);
  virtual bool ReadWord(word& word);
  virtual bool ReadDword(dword& dword);

  // write functions
  virtual int  Write(int num_bytes, const byte* bytes);
  virtual bool WriteByte(byte b);
  virtual bool WriteWord(word w);
  virtual bool WriteDword(dword dw);

private:
  FILE* file;
};


#endif
