#include "FileBuffer.hpp"


////////////////////////////////////////////////////////////////////////////////

CFileBuffer::CFileBuffer(const char* filename, bool open_existing)
{
  file = NULL;
  if (open_existing)
    file = fopen(filename, "r+b");
  if (file == NULL)
    file = fopen(filename, "w+b");
}

////////////////////////////////////////////////////////////////////////////////

CFileBuffer::~CFileBuffer()
{
  if (file)
    fclose(file);
}

////////////////////////////////////////////////////////////////////////////////

bool
CFileBuffer::IsOpen() const
{
  return (file != NULL);
}

////////////////////////////////////////////////////////////////////////////////

dword
CFileBuffer::Size()
{
  long cur = ftell(file);
  fseek(file, 0, SEEK_END);
  dword size = ftell(file);
  fseek(file, cur, SEEK_SET);
  return size;
}

////////////////////////////////////////////////////////////////////////////////

void
CFileBuffer::Seek(dword location)
{
  fseek(file, location, SEEK_SET);
}

////////////////////////////////////////////////////////////////////////////////

dword
CFileBuffer::Tell()
{
  return ftell(file);
}

////////////////////////////////////////////////////////////////////////////////

int
CFileBuffer::Read(int num_bytes, byte* bytes)
{
  return fread(bytes, 1, num_bytes, file);
}

////////////////////////////////////////////////////////////////////////////////

bool
CFileBuffer::ReadByte(byte& b)
{
  int c = fgetc(file);
  b = (byte)c;
  return c != EOF;
}

////////////////////////////////////////////////////////////////////////////////

bool
CFileBuffer::ReadWord(word& w)
{
  byte a, b;
  if (!ReadByte(a))
    return false;
  if (!ReadByte(b))
    return false;
  w = (b << 8) + a;
  return true;
}

////////////////////////////////////////////////////////////////////////////////

bool
CFileBuffer::ReadDword(dword& dw)
{
  word a, b;
  if (!ReadWord(a))
    return false;
  if (!ReadWord(b))
    return false;
  dw = (b << 16) + a;
  return true;
}

////////////////////////////////////////////////////////////////////////////////

int
CFileBuffer::Write(int num_bytes, const byte* bytes)
{
  return fwrite(bytes, 1, num_bytes, file);
}

////////////////////////////////////////////////////////////////////////////////

bool
CFileBuffer::WriteByte(byte b)
{
  return fputc(b, file) != EOF;
}

////////////////////////////////////////////////////////////////////////////////

bool
CFileBuffer::WriteWord(word w)
{
  if (!WriteByte((w >> 0) & 0xFF))
    return false;
  if (!WriteByte((w >> 8) & 0xFF))
    return false;
  return true;
}

////////////////////////////////////////////////////////////////////////////////

bool
CFileBuffer::WriteDword(dword dw)
{
  if (!WriteWord((word)(dw >>  0) & 0xFFFF))
    return false;
  if (!WriteWord((word)(dw >> 16) & 0xFFFF))
    return false;
  return true;
}

////////////////////////////////////////////////////////////////////////////////
