#ifndef __BUFFER_HPP
#define __BUFFER_HPP


#include "types.h"


class CBuffer
{
public:
  virtual ~CBuffer() { };

  // size/position functions
  virtual dword Size() = 0;
  virtual void  Seek(dword location) = 0;
  virtual dword Tell() = 0;

  // read functions
  virtual int  Read(int num_bytes, byte* bytes) = 0;
  virtual bool ReadByte(byte& b) = 0;
  virtual bool ReadWord(word& w) = 0;
  virtual bool ReadDword(dword& dw) = 0;

  // write functions
  virtual int  Write(int num_bytes, const byte* bytes) = 0;
  virtual bool WriteByte(byte b) = 0;
  virtual bool WriteWord(word w) = 0;
  virtual bool WriteDword(dword dw) = 0;
};


#endif
