function TimedAnimation(animation, loops, totalframes)
{
  if (this instanceof TimedAnimation == false) {
    return new TimedAnimation(animation, loops, totalframes);
  }

  this.animation = animation;
  this.totalframes = (typeof totalframes != 'undefined')? totalframes : animation.getNumFrames();
  if(!loops) loops = 1;
  this.maxframes = loops * this.totalframes;
  this.currentframe = 0;
  this.done = this.totalframes>0 ? false: undefined;
  this.next_update = GetTime() + animation.getDelay();
}


TimedAnimation.prototype.blit = function(x, y) {
  if (GetTime() > this.next_update) {
    this.animation.readNextFrame();
    ++this.currentframe;
    if(this.done===false)
      if(this.currentframe>this.maxframes) this.done = true;
    this.next_update = GetTime() + this.animation.getDelay();
  }
  
  this.animation.drawFrame(x, y);
}
