/**
 * returns degrees * Math.PI / 180.0
 * with a precision error of 8.881784197001252e-16
 */
function DegreesToRadians(degrees) {
	return degrees * 0.017453292519943295;
}

/**
 * Returns radians * 180.0 / Math.PI
 * with a precision error of 3.637978807091713e-12
 */
function RadiansToDegrees(radians) {
	return radians * 57.29577951308232;
}

/**
 * Force a value to be between a lower and higher value and possibly rounding it.
 * @param {number} v Your value can be integer or real
 * @param {number} l Lower value, if v is smaller than this, it will return this number
 * @param {number} h Higher value, if v is bigger than this, it will return this number
 * @param {integer} d Round factor to decimal places (leave undefined if you need not to round)
 * Example:
 *   // Make the x value be inside the screen and integer (round to zero decimals)
 *   x = ClampRound(x, 0, GetScreenWidth(), 0);
 */
function ClampRound(v, l, h, d) {
	if (v < l+Clamp.delta) return l;
	if (v > h-Clamp.delta) return h;
	if(typeof d != 'number') return v;
	d = Math.pow(10,d);
	return Math.round(v*d)/d;
}
Clamp.delta = 0.0001;

/**
 * Force a value to be between a lower and higher value, including these values.
 * @param {number} v Your value can be integer or real
 * @param {number} l Lower value, if v is smaller than this, it will return this number
 * @param {number} h Higher value, if v is bigger than this, it will return this number
 * note: 25% faster than ClampRound() but there's no rounding.
 */
function Clamp(v,l,h){ return v<l?l:v>h?h:v; }

/**
 * Rounds a number to a d decimal points
 * param {number} v Your value can be integer or real
 * @param {integer} d Round factor to decimal places (required)
 * Example:
 *   n = 2.415; Abort( Round(n, 2) ); // returns 2.42
 */
function Round(v,d){ d = Math.pow(10,d); return Math.round(v*d)/d;}
