EvaluateSystemScript("flik_menu.js");
EvaluateSystemScript("print.js");


///////////////////////////////////////////////////////////

function DoesGameExist(directory)
{
  var game_list = GetGameList();
  var i=game_list.length-1;
  do{
    if(game_list[i].directory == directory) return true;
  }while(i--);
  return false;
}

///////////////////////////////////////////////////////////

function DigitalClock()
{

   var time = new Date()
   var hour = time.getHours()
   var minute = time.getMinutes()
   var second = time.getSeconds()
   var temp = "" + ((hour > 12) ? hour - 12 : hour)
   if (hour == 0)
      temp = "12";
   temp += ((minute < 10) ? ":0" : ":") + minute
   temp += ((second < 10) ? ":0" : ":") + second
   temp += (hour >= 12) ? " P.M." : " A.M."
   return temp;
}

///////////////////////////////////////////////////////////
function sortByDir(a,b){
	if(a.directory.toUpperCase()<b.directory.toUpperCase())return -1;
	if(a.directory.toUpperCase()>b.directory.toUpperCase())return 1;
	return 0;
}

function GameListMenu() {
  var game_list = GetGameList();
      game_list.sort(sortByDir);

  var menu = DefaultMenu(16, 24, GetScreenWidth() - (48 * 2), (GetScreenHeight() / 6) * 3);
      menu.setWindowStyle(LoadWindowStyle("blue.rws"));

      menu.setArrow(LoadImage("reddot_pointer.png"));
      menu.hspace = 2;
      menu.addDefaultKeys();
      menu.cutOffWidth = false;
      menu.wrap_selection = false;

      menu.mouseSupport=true;
      menu.addDefaultMouseButtons();
      menu.addKey(KEY_ESCAPE, function() { Exit(); });
        
      menu.addKey(KEY_PAGEUP, function() { menu.selection -= 10; if (menu.selection < 0) menu.selection = 0; });
      menu.addKey(KEY_PAGEDOWN, function() { menu.selection += 10; if (menu.selection >= menu.items.length - 1) menu.selection = menu.items.length - 1; });

  if (game_list.length == 0) {
    menu.addText("No games detected.", Exit);
  } else {

    var up_arrow   = GetSystemUpArrow(); //LoadImage("up_arrow.png");
    var down_arrow = GetSystemDownArrow(); //LoadImage("down_arrow.png");
    var block = LoadImage("block.png");

    var info_x = 16;
    var info_y = GetScreenHeight() - (menu.getFont().getHeight() * 6 + 4);
    var info_w = GetScreenWidth() - 32;
    var info_h = menu.getFont().getHeight() * 5 + 5;
    var info_year = new Date().getUTCFullYear();

    var line = CreateSurface(info_w, 2, CreateColor(0,0,0,0));
    line.setBlendMode(REPLACE);
    line.line(0, 0, line.width-2, 0, CreateColor(0,0,0,64));
    line.line(1, 1, line.width  , 1, CreateColor(255,255,255,64));

    Click= CreateSfxr(16,44100,0.5,0,0.56105,0,0,0,0,0,0,0,0,0,0.03083,0.32208,0.115,false,1,0,0,0,0,0,0,0,0.61832,0.50688).getSoundEffect(SE_SINGLE);

    Click.setVolume(16);

    var SphereLogo= LoadImage("logo_engine.png");

    var sphere_str = "Sphere " + GetVersionString() + " 1997->" + info_year + " ";

    var arrow_x = menu.x - Math.max(up_arrow.width, down_arrow.width) +10;
    var up_arrow_y = menu.y;
    var down_arrow_y = menu.y + menu.height - down_arrow.height;

    print.font = menu.getFont();

    var current_item = -1;
    var info_str = "";
    var color ={
         gray:CreateColor(55,55,55,155),
         black:CreateColor(0,0,0,255),
         yellow:CreateColor(255,255,0,255),
         none:CreateColor(255,255,255,255)
    }

    var game_list_str = "Game Folders";
    var game_list_x = menu.x + 16;
    var game_list_y = menu.y - 14;
    
        menu.postRender = function() {
        
          if (current_item != menu.selection) {
	     Click.play(false);
             game_author =    game_list[menu.selection].author;
             game_name = game_list[menu.selection].name;
            var game_desc = game_list[menu.selection].description;
            var game_info = "\n" +game_desc;
            info_str = game_info;
            current_item = menu.selection;
          }

          SphereLogo.blit(GetScreenWidth()-SphereLogo.width-16,0);
          //menu.getFont().drawText(8, 0, sphere_str + DigitalClock());
          print.tint(color.none)(8, 0, sphere_str + DigitalClock());
          

          print.tint(color.yellow)(game_list_x, game_list_y, game_list_str, "O");

          menu.getWindowStyle().drawWindow(info_x, info_y, info_w, info_h);

          print.tint(color.none)(info_x, info_y-5, game_name +" * "+game_author, "O");

          line.blit(info_x, info_y+8);

          // text blocks not yet catered by print()
          menu.getFont().setColorMask(color.gray); // write a shadow
	  menu.getFont().drawTextBox(info_x+1, info_y+1, info_w, info_h, 0, info_str);
	  menu.getFont().setColorMask(color.none); // and now the text
          menu.getFont().drawTextBox(info_x, info_y, info_w, info_h, 0, info_str);

          if (menu.shown_items[0] > 0)
            up_arrow.blit(arrow_x, up_arrow_y);

          block.blit(arrow_x, up_arrow_y +(down_arrow_y - up_arrow_y+8)*((menu.selection)/menu.items.length) )
            
          if (menu.shown_items[menu.shown_items.length - 1] < menu.items.length - 1)
            down_arrow.blit(arrow_x, down_arrow_y);
        }

    for (var i = 0; i < game_list.length; ++i) {
      menu.addText(game_list[i].directory, function() {
        if (DoesGameExist(game_list[menu.selection].directory)) {
          while(IsAnyKeyPressed()){}
          while(AreKeysLeft()){GetKey();}
          ExecuteGame(game_list[menu.selection].directory);
        }
      });
    }
  }

  return menu;
}

///////////////////////////////////////////////////////////

function game(test)
{
  GameListMenu().execute();
// Stop BGM (seems to stay playing on some games)
}

///////////////////////////////////////////////////////////


//Abort(GetFileList("../games/"))
